@echo off
echo ============================================
echo  AKEMI KITCHEN PREP - INSTALLER v1.0.0
echo  Akemi Tech Labs
echo ============================================
echo.
echo NOTE: If Windows shows "Windows protected your PC",
echo click "More info" then "Run anyway". This is normal
echo for new software not yet widely distributed.
echo.
pause

set "SRC=%~dp0"
if "%SRC:~-1%"=="\" set "SRC=%SRC:~0,-1%"
set "DEST=C:\AkemiTechLabs\AkemiKitchenPrep"

echo.
echo Installing to %DEST% ...

if not exist "%DEST%" mkdir "%DEST%"

REM Copy all files from source to destination
xcopy "%SRC%\*" "%DEST%\" /E /Y /Q >nul 2>nul
if %errorlevel% neq 0 (
    echo.
    echo ERROR: Failed to copy files. Try running as Administrator.
    pause
    exit /b 1
)
echo Files copied: OK

echo.
echo Creating desktop shortcut...

REM Try PowerShell shortcut creation
powershell -NoProfile -ExecutionPolicy Bypass -Command "& { $ws = New-Object -ComObject WScript.Shell; $dt = $ws.SpecialFolders('Desktop'); if (-not $dt) { $dt = [Environment]::GetFolderPath('Desktop') }; $lnk = $ws.CreateShortcut($dt + '\Akemi Kitchen Prep.lnk'); $lnk.TargetPath = '%DEST%\akemi_kitchen_prep.exe'; $lnk.WorkingDirectory = '%DEST%'; $lnk.IconLocation = '%DEST%\akemi_tech_labs.ico,0'; $lnk.Description = 'Akemi Kitchen Prep - Akemi Tech Labs'; $lnk.Save(); Write-Host 'Shortcut created on Desktop' }" 2>nul

if %errorlevel% neq 0 (
    echo PowerShell shortcut failed. Trying fallback...
    if exist "%USERPROFILE%\Desktop" (
        set "DESKTOP=%USERPROFILE%\Desktop"
    ) else if exist "%USERPROFILE%\OneDrive\Desktop" (
        set "DESKTOP=%USERPROFILE%\OneDrive\Desktop"
    ) else (
        set "DESKTOP=%PUBLIC%\Desktop"
    )
    (
        echo @echo off
        echo cd /d "%DEST%"
        echo start "" "%DEST%\akemi_kitchen_prep.exe"
    ) > "%DESKTOP%\Akemi Kitchen Prep.bat"
    echo Created launcher on Desktop
)

echo.
echo ============================================
echo   INSTALLATION COMPLETE
echo.
echo   Desktop shortcut: Akemi Kitchen Prep
echo   Install folder: %DEST%
echo   No Python required - standalone .exe
echo   App opens at: http://127.0.0.1:5847
echo ============================================
pause
